<?php

namespace App\Models\Purchase;

use Illuminate\Database\Eloquent\Model;

class PurchaseLine extends Model 
{

    protected $table = 'purchase_lines';
    public $timestamps = true;
    protected $fillable = array('qty', 'price', 'amount', 'added_to_pr');

    public function product()
    {
        return $this->belongsTo('Product', 'product_id', 'id');
    }

    public function purchaserequest()
    {
        return $this->belongsTo('Purchase', 'purchaserequest_id', 'id');
    }

}